define([
    'marionette',
    'text!modules/new-appointment-request/views/direct/preferred-date/templates/preferred-date-available.html',
    'modules/new-appointment-request/views/direct/preferred-date/date-collapsible',
],
function(
    Marionette,
    template,
    DateCollapsibleView
) {
    'use strict';

    // reduces rendering time with prerendered collapsible;
    // given this.model (with date and timeSlots),
    // create this.collection and show child views on expand
    return Marionette.View.extend({
        template: template,
        regions: {containerRegion: '.available-dates'},
        initialize: function(options) {
            var dateLength = 10;
            var date = this.model.get('desiredDate').substring(0, dateLength);
            this.timeSlotsOnPreferredDate = options.timeSlotsByDateCollection.get(date);
        },
        onRender: function() {
            this.showDateCollapsibleView();
            this.$el.trigger('create');
            this.focusOnLegend();

        },
        focusOnLegend: function() {
            // iOS Safari unable to focus on legend, focusing on text in legend instead
            this.$el.find('legend span[tabindex]').focus();
        },
        showDateCollapsibleView: function() {

            if (!this.isDestroyed()) {
                this.showChildView('containerRegion', new DateCollapsibleView({
                    model: this.timeSlotsOnPreferredDate,
                    collapsed: false,
                }));
            }
        },
    });
});
